#ifndef SCUBE
#define SCUBE

#include <vector>
using namespace std;

struct intpoint{
  int x,y,z;
  intpoint() {x=0; y=0; z=0;};
  intpoint(const intpoint& p) {x=p.x; y=p.y; z=p.z;};
  intpoint(int x0,int y0, int z0) {x=x0; y=y0; z=z0;};
  intpoint operator +(intpoint p);
  intpoint operator -(intpoint p);
  intpoint operator %(intpoint p);
  intpoint operator %(int m);
  intpoint& operator %=(int m);
};

// The class symmetric cube represents a grid that is periodic and cubically symmetric.
// (0,0,0) is the center of the cube, and (n-1,n-1,n-1) is the (only) corner.
// All the coordinates are mapped to a symmetric point such that n > x >= y >= z >=0.
class scube{
  // the private grid
  vector<double> g;
  int _n;
  // private methods
  intpoint map(intpoint p);
  // friend double median(scube&);
  public:
    // The constructor creates a symmetric cube of 2n (distinct) vertices by edge.
    scube(int n=1);
    scube(const scube& c);
    // The difference between get() and plainget() is that for plainget it is assumed
    // that the given coordinates are already in the fundamental tetrahedron.
    double& get(int x, int y, int z);
    double& get(intpoint p);
    double& plainget(int x, int y, int z);
    // clear() makes it all zeroes.
    void clear();
    // size() returns the number of points per edge.
    int size() const {return _n;};
    vector<double>& raw() {return g;};

    scube& operator=(const scube& c);

    // Returns an interpolated scube of 2n vertices by edge
    scube interpolate(int n);
};

#endif
