#include "scube.h"

inline void swap(double& x, double & y){
  double a=x;
  x = y;
  y = a;
}

// Methods of intpoint
intpoint intpoint::operator +(intpoint p){
  intpoint res;
  res.x = x + p.x;
  res.y = y + p.y;
  res.z = z + p.z;
  return res;
}

intpoint intpoint::operator -(intpoint p){
  intpoint res;
  res.x = x - p.x;
  res.y = y - p.y;
  res.z = z - p.z;
  return res;
}

intpoint intpoint::operator %(intpoint p){
  intpoint res;
  res.x = x % p.x;
  res.y = y % p.y;
  res.z = z % p.z;
  return res;
}

intpoint intpoint::operator %(int m){
  intpoint res;
  res.x = x % m;
  res.y = y % m;
  res.z = z % m;
  return res;
}

intpoint& intpoint::operator %=(int m){
  x = x % m;
  y = y % m;
  z = z % m;
  return *this;
}

// Methods of scube

intpoint scube::map(intpoint p){
  // bring it close. most likely it is not necessary.
  p %= (2*(_n-1));

  // map to the first quadrant.
  if(p.x < 0) p.x = -p.x;
  if(p.y < 0) p.y = -p.y;
  if(p.z < 0) p.z = -p.z;
  if(p.x >= _n) p.x = 2*_n -2 - p.x;
  if(p.y >= _n) p.y = 2*_n -2 - p.y;
  if(p.z >= _n) p.z = 2*_n -2 - p.z;

  // map it to the fundamental tetraedom
  if (p.x < p.y) swap(p.x,p.y);
  if (p.x < p.z) swap(p.x,p.z);
  if (p.y < p.z) swap(p.y,p.z);
  return p;
}

// The constructor creates a symmetric cube of 2n-1 vertices by edge.
scube::scube(int n){
  g.resize(n*(n+1)*(n+2)/6);
  _n = n;
}

scube::scube(const scube& c){
  g = c.g;
  _n = c.size();
}

double& scube::plainget(int x, int y, int z){
  return g[ x*(x+1)*(x+2)/6 + y*(y+1)/2 + z ];
}

double& scube::get(int x, int y, int z){
  return get(intpoint(x,y,z));
}

double& scube::get(intpoint p){
  p = map(p);
  return plainget(p.x,p.y,p.z);
}

void scube::clear(){
  for(int i=0; i<g.size(); ++i){
    g[i]=0;
  }
}

scube& scube::operator=(const scube& c){
  g = c.g;
  _n = c.size();
  return (*this);
}

scube scube::interpolate(int n){
  scube r(n);
  for(int x=0; x<n; ++x){
    for(int y=0; y<=x; ++y){
      for(int z=0; z<=y; ++z){
        int x0 = int((double(x) / (n-1)) * (_n-1));
        int y0 = int((double(y) / (n-1)) * (_n-1));
        int z0 = int((double(z) / (n-1)) * (_n-1));
        double cx = ((double(x0+1) / (_n-1)) - (double(x) / (n-1))) * (_n-1);
        double cy = ((double(y0+1) / (_n-1)) - (double(y) / (n-1))) * (_n-1);
        double cz = ((double(z0+1) / (_n-1)) - (double(z) / (n-1))) * (_n-1);
        r.plainget(x,y,z) = cx*cy*cz*get(x0,y0,z0) + (1-cx)*cy*cz*get(x0+1,y0,z0) +
            cx*(1-cy)*cz*get(x0,y0+1,z0) + (1-cx)*(1-cy)*cz*get(x0+1,y0+1,z0) + 
            cx*cy*(1-cz)*get(x0,y0,z0+1) + (1-cx)*cy*(1-cz)*get(x0+1,y0,z0+1) + 
            cx*(1-cy)*(1-cz)*get(x0,y0+1,z0+1) + (1-cx)*(1-cy)*(1-cz)*get(x0+1,y0+1,z0+1);
      }
    }
  }
  return r;
}
