/************************************************************
Program to compute the effective conductivity of a composite
using an adaptive finite element method.

Programmed by: Luca Heltai - Feb 2007

Requires the library dealii to compile.
*************************************************************/

#ifndef PARSED_FUNCTION_H
#define PARSED_FUNCTION_H

#include <base/auto_derivative_function.h>
#include <base/function_parser.h>
#include <base/parameter_handler.h>
#include <base/function.h>
#include <base/point.h>
#include <base/tensor.h>

#include <lac/vector.h>

using namespace dealii;

template <int dim>
class ParsedFunction :  public AutoDerivativeFunction<dim> 
{
    public:
	/** Construct a vector function. */
	ParsedFunction (unsigned int vdim = 1);

	/** Declare parameters needed by this class. */
	static void declare_parameters(ParameterHandler &prm, 
		unsigned int vdim = 1);

	/** Parse parameters needed by this class. */
	void parse_parameters(ParameterHandler &prm);

	/** Get ONE value at the given point.  This value is the force
	  density at the given point.*/ 
	virtual void vector_value (const Point<dim> &p,
		Vector<double>   &values) const;

	/** Return the value of the function at the given point. Unless there is only one component 
	  (i.e. the function is scalar), you should state the component you want to have evaluated;
	  it defaults to zero, i.e. the first component. */
	virtual double value (const Point< dim > &    p,
		const unsigned int  component = 0)    const;
	
	/** We need to overwrite this to set the time also in the accessor FunctionParser<dim>. */
	virtual void set_time(const double newtime);
    private:
	FunctionParser<dim> f;
};

#endif
